clc;
clear all;


observation_ratio_array = 0.5:0.05:0.95;
rank_array = 2:2:20;

sigma = 0;

m = 1000;
n = 100;

num_trial = 1;

time_tnnm = zeros(numel(observation_ratio_array), numel(rank_array), num_trial);
error_tnnm = zeros(numel(observation_ratio_array), numel(rank_array), num_trial);


for idx_ratio=1:length(observation_ratio_array)
    ratio = observation_ratio_array(idx_ratio);
    
    for idx_rank=1:length(rank_array)
        r0 = rank_array(idx_rank);
        
        fprintf('observation ratio: %1.2f  rank: %d\n', ratio, r0);
        
        for idx_trial=1:num_trial            
            % Generate the matrix with the given parameters
            XL = randn(m,r0) + rand(m,r0)-0.5;
            XR = randn(r0,n) + rand(r0,n)-0.5;
           
            X0 = XL*XR;
            
            % Get Omega
            indices = sort(randperm(m*n, ceil(ratio*m*n)));
            
            Omega = zeros(m,n);
            Omega(indices) = 1;

            D = (X0 + sigma*randn(size(X0))).*Omega;
            
            % TNNM_ALM
            tic
            X_hat_tnnm = TNNM_ALM(D, Omega, r0, 2e-3, sigma);
            time_tnnm(idx_ratio, idx_rank, idx_trial) = toc;
            
            error_tnnm(idx_ratio, idx_rank, idx_trial) = norm(X0-X_hat_tnnm,'fro')/norm(X0, 'fro');
        end
    end
end

avg_time_tnnm = mean(time_tnnm,3);
avg_error_tnnm = mean(error_tnnm,3);


% Visualization
createfigure(avg_error_tnnm, rank_array, observation_ratio_array, 0.002, 'Reconstruction error', 18);
createfigure(avg_time_tnnm, rank_array, observation_ratio_array, 2, 'Execution time', 18);



