function figure1 = createfigure(cdata1, tick_x, tick_y, max_range, str_title, font_size)

% Create figure
figure1 = figure('Color',[1 1 1]);

tick_y = reshape(tick_y, 2, numel(tick_y)/2);
tick_x = reshape(tick_x, 2, numel(tick_x)/2);

for i=1:size(tick_y,2)
    tick_y_str(i) = {num2str(tick_y(1,i))};
end
for i=1:size(tick_x,2)
    tick_x_str(i) = {num2str(tick_x(2,i))};
end

% Create axes
axes1 = axes('Parent',figure1,...
    'YTickLabel',tick_y_str,...
    'YTick',[1:2:numel(tick_y)],...
    'XTickLabel',tick_x_str,...
    'XTick',[2:2:numel(tick_x)],...
    'Position',[0.228571428571428 0.0404761904761905 0.506547619047619 0.923809523809525],...
    'FontSize',font_size,...
    'Layer','top',...
    'DataAspectRatio',[1 numel(tick_y)/numel(tick_x) 1],...
    'FontName','Times New Roman');
%     'Position',[0.1875 0.0547619047619048 0.506547619047619 0.923809523809525],...
%     'Position',[0.075 0.05 0.630357142857143 0.923809523809525],...

xlim(axes1,[0.5 numel(tick_x)+0.5]);
ylim(axes1,[0.5 numel(tick_y)+0.5]);

box(axes1,'on');
hold(axes1,'all');

% Create image
% image(cdata1,'Parent',axes1,'CDataMapping','scaled');
imagesc(cdata1,[0 max_range]);

% Create xlabel
xlabel({'Rank'}, 'FontSize',font_size, 'FontName','Times New Roman');
% xlabel({'rank'},'FontName','Palatino Linotype');

% Create ylabel
ylabel({'Observation ratio'}, 'FontSize',font_size, 'FontName','Times New Roman');
% ylabel({'missing data rate'},'FontName','Palatino Linotype');

% Create colorbar
colorbar('peer',axes1, 'FontSize',font_size, 'FontName','Times New Roman');
% colorbar('peer',axes1,'FontName','Palatino Linotype');

% Create title
if nargin == 5
    title(str_title);
end

% Resize the axes in order to prevent it from shrinking.
set(axes1,...
    'Position',[0.228571428571428 0.0404761904761905 0.506547619047619 0.923809523809525]);
