function X = TNNM_ALM(D, known, r, kappa, sigma)
    X = D;
    L = D;
    S = zeros(size(D));

    eps = 1e-4;
    rho = 1.5;
    mu = 1.25/norm(D);
    mu_max = 1e6;
    max_iter = 1000;

    delta = sqrt(sum(known(:)) + sqrt(8*sum(known(:))))*sigma;
    
    for k=1:max_iter
        % update X
        X_old = X;
        X = psvt(D.*known - S + L/mu, 1/mu, r);
        
        % update S
        Y = D.*known - X + L/mu;
        S = Y.*~known + Y.*known*min(1, delta/norm(Y.*known,'fro'));
        
        % update Lambda
        L = L + mu*(D.*known - X - S);        
        
        stopCriterion1 = norm(D.*known - X - S,'fro')/norm(D, 'fro');
        stopCriterion2 = norm(X_old-X,'fro')/norm(D, 'fro');
        if max(stopCriterion1, stopCriterion2) < eps
            break;
        end
        
        if mu*stopCriterion2 < kappa
            mu = min(rho*mu, mu_max) ;
        end
    end
end


function Xd = psvt(X, tau, r)
    [U,S,V] = svd(X, 'econ');
    
    diagS = diag(S);
    diagS2 = nonzeros(max(diagS(r+1:end)-tau,0));
    
    svp = length(diagS2);

    Xd = U(:, 1:r) * S(1:r,1:r) * V(:, 1:r)';

    if svp >= 1
        Xd = Xd +  U(:, r+1:r+svp) * diag(diagS2) * V(:, r+1:r+svp)';
    end
end


