% function pixel_value = iCRF(CRF, radiance, T)
% l = log(radiance*T);
% 
% [~,pixel_value] = min(abs(CRF-l));
% 
% pixel_value = pixel_value - 1;
% end
% 


% CRF2 = CRF(:,1);
% T2 = T(3);
% radiance2 = [17; 18];
% radiance3 = [17, 18];
% radiance4 = [17, 18; 18, 20];
% 
% radiance = radiance3;

function pixel_value = iCRF(CRF2, radiance, T)

rad_column = radiance(:);

l = log(rad_column*T);
diff = zeros(length(rad_column), 256);

for n=1:256
    diff(:,n) = abs(l-CRF2(n));
end 

[~,pixel_value] = min(diff, [], 2);

pixel_value = pixel_value - 1;

pixel_value = reshape(pixel_value, size(radiance));
end

