function CRF = getCRF(stack, T)


zMax = 255;
zMin = 0;
zMid = (zMax + zMin) * 0.5;

weight = zeros(256,1);

for h = 1:256
    if (h-1) > zMid
        weight(h) = zMax - (h - 1);
    else
        weight(h) = (h - 1) - zMin;
    end
end


stack_hist = ComputeLDRStackHistogram(stack);
stack_samples = GrossbergSampling('', '', stack_hist, 100);%StackLowRes(stack);

intensityRange = 256;     % The range of intensity, which is 256.
CRF = zeros(intensityRange, 3);
for i=1:3
    CRF(:,i) = gsolve(stack_samples(:,:,i),log(T),20,weight);
end

% % Initial Setting.
% zMax = 255;
% zMin = 0;
% zMid = (zMax + zMin) * 0.5;
% intensityRange = 256;     % The range of intensity, which is 256.
% 
% CRF = zeros(intensityRange, 3);
% 
% Lamda = 100;
% 
% % Create the single weight matrix.
% for h = 1:256
%     if (h-1) > zMid
%         weight(h) = zMax - (h - 1);
%     else
%         weight(h) = (h - 1) - zMin;
%     end
% end
% 
% 
% % Calculate the radiance.
% % pixel{i}: A Nx2 matrix which records the pixels with intensity {i-1}
% % points: A 256x3 matrix. The first two columns represent their locations,
% % while the last column represents their intensity.
% % weight: A matrix with the size of 256 which represents the weight of each
% % intensity.
% for a = 1:3
%     % Read in and process R, G, B separately.
%     if a == 1
%         colorImage = RED;
%     elseif a ==2
%         colorImage = GREEN;
%     else
%         colorImage = BLUE;
%     end
%     % Categorize pixels with different intensity into differeny groups.
%     numPixel = 0;     % The total number of pixel that is going to be used in radiance.
%     for b = 1:256
%         [tempRow, tempCol] = find(colorImage(:,:,round(size(colorImage,3)/2)) == b-1);
%         if isempty(tempRow)
%             trash = 0;
%         else
%             % Select a point to make sure its intensity in different
%             % frame doesn't repeat.
%             potentialPoints = [tempRow tempCol];
%             % Randomly pick one point from "potentialPoints" and generate
%             % weight matrix.
%             if size(potentialPoints, 1) > 1
%                 numPixel = numPixel + 1;
%                 pixel{numPixel} = [tempRow tempCol];
%                 pick = floor(rand * (size(potentialPoints,1) - 1)) + 1;
%                 points(numPixel, :) = [potentialPoints(pick,1) potentialPoints(pick,2) (b-1)];
%             end
%         end
%     end
%     
%     % Generate the calculation matrices.
%     A = zeros((numPixel*size(colorImage,3)) + 254 + 1, intensityRange + numPixel);
%     B = zeros(size(A,1), 1);
%     p = 0;
%     for i = 1:numPixel
%         for j = 1:size(colorImage,3)
%             p = p + 1;
%             A(p, colorImage(points(i,1), points(i,2), j) + 1) = weight(colorImage(points(i,1), points(i,2), j) + 1);
%             A(p, intensityRange + i) = -weight(colorImage(points(i,1), points(i,2), j) + 1);
%             B(p, 1) = weight(colorImage(points(i,1), points(i,2), j) + 1) * log(T(j));
%             
%         end
%     end
%     % Fill in the punishing terms.
%     for d = (zMin + 1):(zMax - 1)
%         A(numPixel*size(colorImage,3) + d, d) = Lamda * weight(d + 1);
%         A(numPixel*size(colorImage,3) + d, d + 1) = -2 * Lamda * weight(d + 1);
%         A(numPixel*size(colorImage,3) + d, d + 2) = Lamda * weight(d + 1);
%     end
%     % Add the constraint term to set the g(mid intensity) = 0
%     A(end, (round(size(points,1)/2) + 1)) = 1;
%     % Use SVD to solve the equation.
%     X = pinv(A) * B;
%     CRF(:, a) = X(1:intensityRange);
% end

  
  
  
  
function [FileList] = dig(FilePath,FileList,FileExt,verbose)
dirList = dir(FilePath);
ridx = strcmp({dirList.name},'.') | strcmp({dirList.name},'..');
dirList(ridx) = [];
if size(dirList,2) ~= 0
    for listing = 1:size(dirList,1)
        current_Path = [FilePath dirList(listing).name];
        typed_path = regexprep(current_Path,'\','\\\');
        if verbose
            fprintf(['Looking at:' typed_path '\n']);
        end
        if dirList(listing).isdir
            FileList = dig([current_Path '\'],FileList,FileExt,verbose);
        else
            FileExt;
            dirList(listing).name(end-2:end);
            if any(strcmp(FileExt,dirList(listing).name(end-2:end)))
                FileList{end+1,1} = current_Path;
            end
        end
    end
end