clear all;

image_db = '../data/SculptureGarden/';
image_name = 'garden';


%%%% Input images  %%%%%
FileList = getFilelist(image_db, 'bmp');

if exist('in_image', 'var') == 1
    clear in_image;
end

for s = 1:size(FileList,1)
    in_image(:,:,:,s) = imread(FileList{s});
end
%%%%%%%%%%%%%%%%%%%%%%%%%

%%%% Exposure times  %%%%
ExFileName = getFilelist(image_db, 'txt');
fid = fopen(char(ExFileName));

T = fscanf(fid, '%d', inf);
T = 1./T';

fclose(fid);
%%%%%%%%%%%%%%%%%%%%%%%%%


%%%% RM-HDR %%%%%%%%%%%%%
idx_ref = floor((length(T)+1)/2);

CRF = getCRF(in_image, T);

hdr = RM_HDR(in_image, CRF, T, idx_ref);
%%%%%%%%%%%%%%%%%%%%%%%%%

   
rgb = tonemap(hdr, 'AdjustLightness', [0.01 0.99], 'AdjustSaturation', 1.75);
rgb = uint8(((double(rgb)/255).^(1/0.75))*255);
    
% imwrite(rgb, sprintf('hdr_%s_rm.png', char(image_name)));
% save_exr(hdr, sprintf('hdr_%s_rm.exr', char(image_name)));

