function hdr = RM_HDR(in_image, CRF, T, idx_ref)

addpath(genpath('gco-v3.0'))

tic

H = size(in_image, 1);
W = size(in_image, 2);
N = size(in_image, 4);


Omega = ones(size(in_image));
Omega(in_image == 255) = 0;
Omega(in_image == 0) = 0;
Omega1 = 1 - Omega;

Omega = reshape(Omega, W*H*3, N);

logE = zeros(size(in_image));
radiance = zeros(size(in_image));

for idx_ex=1:N
    for idx_clr=1:3
        logE(:,:,idx_clr,idx_ex) ...
            = reshape(CRF(in_image(:,:,idx_clr,idx_ex) + 1, ...
            idx_clr), H, W) - log(T(idx_ex));
        
        radiance(:,:,idx_clr,idx_ex) = double(iCRF(CRF(:,idx_clr), ...
            exp(logE(:,:,idx_clr,idx_ex)), T(idx_ref)));
    end
end

radiance = radiance/255;


%%%% MCR %%%%%%%%%%%%%%%%%%%%%%%
D = reshape(radiance, H*W*3, N);

A_hat = zeros(size(D));
E_hat = zeros(size(D));

res = H*W;
for idx_clr=1:3
    in_data = squeeze(radiance(:,:,idx_clr,:));
    in_omega = squeeze(Omega1(:,:,idx_clr,:));
    
    [A, E]  = SolveOptimization(in_data, in_omega);
    A_hat((idx_clr-1)*res+1:idx_clr*res,:) = reshape(A, res, N);
    E_hat((idx_clr-1)*res+1:idx_clr*res,:) = reshape(E, res, N);
end

A_hat_rad = reshape(A_hat, size(in_image));
E_hat_rad = reshape(E_hat, size(in_image));
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%


%%%% GHOST DETECTION %%%%%%%%%%%
if exist('g_map', 'var') == 1
    clear g_map;
end

g_map = zeros(H, W, N);
for idx_ex=1:N
    g_map(:,:,idx_ex) = 1 - (sum(E_hat_rad(:,:,:,idx_ex),3) >=1 );
    
    %%%% G MAPS %%%%
%     gmap_file_name = sprintf('gmap_%s_mcr_%d.png', char(image_name_array(idx_image)), idx_ex);
%     imwrite(g_map(:,:,idx_ex), gmap_file_name);
%     g_map(:,:,idx_ex) = imread(gmap_file_name)/255;
    %%%%%%%%%%%%%%%%
end
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%%%% HDR SYNTHESIS %%%%%%%%%%%%%
weight = zeros(256, 1);
for h = 1:256
    if (h-1) > 128
        weight(h) = 255 - (h - 1);
    else
        weight(h) = (h - 1) - 0;
    end
end

Omega2 = 1 - squeeze(sum(Omega1,3)>0);

for r = 1:N
    if r ~= idx_ref
%         g_map(:,:,r) = Omega2(:,:,r).* g_map(:,:,r) .* g_map(:,:,idx_ref);
        g_map(:,:,r) = g_map(:,:,r) .* g_map(:,:,idx_ref);
        
        se = strel('disk',1);
        g_map(:,:,r) = imdilate(g_map(:,:,r),se);
        se = strel('disk',2);
        g_map(:,:,r) = imerode(g_map(:,:,r),se);
    end
end
g_map(:,:,idx_ref) = ones(H,W);

hdr = zeros(H,W,3);
for idx_color = 1:3
    numerator = zeros(H,W);
    denominator = zeros(H,W);
    for r = 1:N
        w = g_map(:,:,r).*weight(in_image(:,:,idx_color,r) + 1);
        denominator = denominator + w;
        numerator = numerator + w .* exp(logE(:,:,idx_color,r));
    end
    Ei = ones(H,W);
    
    idx = find(denominator>0);
    Ei(idx) = numerator(idx) ./ denominator(idx);
    
    hdr(:,:,idx_color) = Ei;
end
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%



